(defparameter *agent-model-code* 
  '((sgp :v t :needs-mouse nil :esc t :lf .05 :trace-detail low :imaginal-delay 0 :model-warnings nil)

	(chunk-type (game-element (:include visual-object))
						world-position-x 
						world-position-y
						world-position-z
						element-height 
						element-width 
						world-distance 
						screen-x 
						screen-y 
						screen-width 
						screen-height
						element-type 
						element-color)
	
	(chunk-type game-goal cycle-count current-task task-status task-start-time simulation-cycle-count)

	(add-dm  
		(g1 isa game-goal task-status nil current-task waiting-to-start)

	)

;;;;;;;;START;;;;;;;;;;

	(p wait-for-start
		=goal>
			isa		game-goal
			current-task		waiting-to-start
			cycle-count =time
		=self>
			isa		self
			ready-interval-delay =interval-delay ;;ready-interval-delay is the delay time (in msecs) that the agent needs to wait before starting the task
			agent-name =name
		!eval! (= (/ =interval-delay 1000) =time) ;;check that a sufficient number of cycles have elapsed
	==>
		!eval! (add-triple =name 'is-ready 'yes) ;;add a triple to indicate that the agent is ready
		=goal>
			current-task begin-task
			task-status waiting ;;set the status to waiting - this pauses activity until other agents are ready
	)

	(p start-task
		=goal>
			isa		game-goal
			current-task		begin-task
			cycle-count =cycle-count
			task-status start ;; this status value is set by the system and it indicates that agents can begin the task
		=self>
			isa self
			agent-name =agent-name
	==>
		!bind! =task-start-time (+ =cycle-count 1) 
		=goal>
			current-task play-game
			task-start-time =task-start-time
			task-status starting
	)

;;;;;;;;PLAY GAME PRODUCTIONS;;;;;;;;;;

	(p start-moving-forward
		=goal>
			isa		game-goal
			current-task		play-game
			cycle-count 14
			- task-status move-forward
		=self>
			isa self
			agent-name agent-1
	==>
		=goal>
			task-status move-forward
	)

	(p start-moving-backward
		=goal>
			isa		game-goal
			current-task		play-game
			cycle-count 16
			- task-status move-backward
		=self>
			isa self
			agent-name agent-1
	==>
		=goal>
			task-status move-backward
	)

	(p start-moving-left
		=goal>
			isa		game-goal
			current-task		play-game
			cycle-count 18
			- task-status move-left
		=self>
			isa self
			agent-name agent-1
	==>
		=goal>
			task-status move-left
	)

	(p start-moving-right
		=goal>
			isa		game-goal
			current-task		play-game
			cycle-count 20
			- task-status move-right
		=self>
			isa self
			agent-name agent-1
	==>
		=goal>
			task-status move-right
	)

	(p start-looking-left
		=goal>
			isa		game-goal
			current-task		play-game
			cycle-count 22
			- task-status look-left
		=self>
			isa self
			agent-name agent-1
	==>
		=goal>
			task-status look-left
	)

	(p start-looking-right
		=goal>
			isa		game-goal
			current-task		play-game
			cycle-count 24
			- task-status look-right
		=self>
			isa self
			agent-name agent-1
	==>
		=goal>
			task-status look-right
	)

	(p start-shooting
		=goal>
			isa		game-goal
			current-task		play-game
			cycle-count 26
			- task-status shoot
		=self>
			isa self
			agent-name agent-1
	==>
		=goal>
			task-status shoot
	)

	(p start-highlighting-visicon
		=goal>
			isa		game-goal
			current-task		play-game
			cycle-count 28
			- task-status highlight-visicon
			- task-status visicon-highlighted
		=self>
			isa self
			agent-name agent-1
	==>
		=goal>
			task-status highlight-visicon
	)

	(p start-updating-visicon
		=goal>
			isa		game-goal
			current-task		play-game
			cycle-count 30
			- task-status update-visicon
			- task-status visicon-updated
		=self>
			isa self
			agent-name agent-1
	==>
		=goal>
			task-status update-visicon
	)

	(spp start-moving-forward :u 20)
	(spp start-moving-backward :u 20)
	(spp start-moving-left :u 20)
	(spp start-moving-right :u 20)
	(spp start-looking-left :u 20)
	(spp start-looking-right :u 20)
	(spp start-shooting :u 20)
	(spp start-highlighting-visicon :u 20)
	(spp start-updating-visicon :u 20)

	(p move-forward
		=goal>
			isa		game-goal
			current-task		play-game
			task-status move-forward
		=self>
			isa self
			agent-name agent-1
	==>
		+xna>
			isa comment
			text "MOVEFORWARD"
	)

	(p move-backward
		=goal>
			isa		game-goal
			current-task		play-game
			task-status move-backward
		=self>
			isa self
			agent-name agent-1
	==>
		+xna>
			isa comment
			text "MOVEBACKWARD"
	)	

	(p move-left
		=goal>
			isa		game-goal
			current-task		play-game
			task-status move-left
		=self>
			isa self
			agent-name agent-1
	==>
		+xna>
			isa comment
			text "MOVELEFT"
	)	

	(p move-right
		=goal>
			isa		game-goal
			current-task		play-game
			task-status move-right
		=self>
			isa self
			agent-name agent-1
	==>
		+xna>
			isa comment
			text "MOVERIGHT"
	)	

	(p look-left
		=goal>
			isa		game-goal
			current-task		play-game
			task-status look-left
		=self>
			isa self
			agent-name agent-1
	==>
		+xna>
			isa comment
			text "LOOKLEFT"
	)	

	(p look-right
		=goal>
			isa		game-goal
			current-task		play-game
			task-status look-right
		=self>
			isa self
			agent-name agent-1
	==>
		+xna>
			isa comment
			text "LOOKRIGHT"
	)	

	(p shoot
		=goal>
			isa		game-goal
			current-task		play-game
			task-status shoot
		=self>
			isa self
			agent-name agent-1
	==>
		+xna>
			isa comment
			text "SHOOT"
	)	

	(p highlight-visicon
		=goal>
			isa		game-goal
			current-task		play-game
			task-status highlight-visicon
		=self>
			isa self
			agent-name agent-1
	==>
		=goal>
			task-status visicon-highlighted
		+xna>
			isa comment
			text "HIGHLIGHTVISICON"
	)

	(p update-visicon
		=goal>
			isa		game-goal
			current-task		play-game
			task-status update-visicon
		=self>
			isa self
			agent-name agent-1
	==>
		=goal>
			task-status visicon-updated
			current-task process-display
		+xna>
			isa comment
			text "GETVISICON"
	)

	(P find-unattended-object
		=goal>
			isa game-goal
			current-task process-display
			task-status visicon-updated
	==>
		+visual-location>
			isa        visual-location
			:attended    nil
		=goal>
			task-status       find-location
	)

	(P attend-object
		=goal>
			isa         game-goal
			current-task process-display
			task-status find-location
		=visual-location>
			isa         visual-location
		?visual>
			state       free
		==>
		+visual>
			isa         move-attention
			screen-pos  =visual-location
		=goal>
			task-status       attend
	)

	(P encode-object
		=goal>
			isa         game-goal
			current-task process-display
			task-status attend
		=visual>
			isa         game-element
	==>
		=goal>
			task-status respond
		+imaginal> =visual
	)


	(P respond
		=goal>
			isa         game-goal
			current-task process-display
			task-status respond
		=imaginal>
			isa        game-element
			world-position-x =world-position-x
			world-position-y =world-position-y
			world-position-z =world-position-z
			element-height =height
			element-width =width
			world-distance =world-distance 
			screen-x  =screen-x
			screen-y =screen-y
			screen-width =screen-width
			screen-height =screen-height
			element-type  =element-type
			element-color =element-color
	==>
		!bind! =response-string (concatenate 'string
			(write-to-string =world-position-x) ","
			(write-to-string =world-position-y) ","
			(write-to-string =world-position-z) ","
			(write-to-string =height) ","
			(write-to-string =width) ","
			(write-to-string =world-distance) "," 
			(write-to-string =screen-x) ","
			(write-to-string =screen-y) ","
			(write-to-string =screen-width) ","
			(write-to-string =screen-height) ","
			(string =element-type) ","
			(string =element-color))
		=goal>
			task-status stop
			current-task nothing
		+xna>
			isa comment
			text =response-string
)

	(goal-focus g1) 
	
))
